/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/   

/**
 * \file    Boot-Mode.c
 *
 * \brief   Main Entry Function for Boot-Mode testing.
 *
 * This file contains the Main routine for testing 
 * Bootmode of the DM814X EVM.
 * 
 * \ author
 * 
 * \version  
 */
 
/* ======================
 *  Includes
 * ======================
 */
#include "DM814x_EVM.h"
#include "DM814x_soc.h"
#include "DM814x_types.h"
#include "stdio.h"

/* =====================
 * Defines
 * =====================
 */
#define DM814X_BOOT_MODE_ADDR	(0x48140040)

/** **************************************************************************
 * \n \main rotuine to test the BOOt-Mode.
 *
 * This routine reads the Boot mode switch and verifes the same. 
 * 
 * 
 */
int main()
{
	UINT32	u32BootMode = 0;

    /* Initialize EVM */
	DM814x_EVM_Init ();	
	
	printf ("Reading the boot mode switch settings !!.\r\n");
	u32BootMode = *(UINT32*) DM814X_BOOT_MODE_ADDR;

	printf("Boot-Mode switch settings read is %x", u32BootMode);

	return 0;

}
 

    
   
